# Unusual Database (unu_db)

## Overview
Unusual Database is a simple UDP-based key-value storage system with client-server architecture.

## Prerequisites
- Windows operating system
- Command prompt or terminal

## Server Setup and Operation

### Starting the Server
1. Open command prompt
2. Navigate to the directory containing `unusual_database.exe`
3. Run the server with optional parameters:
   ```
   unusual_database.exe -h [HOSTNAME] -p [PORT]
   ```
   - Default: Hostname = 192.168.50.82, Port = 2001
   - If no parameters provided, default settings will be used

### Server Features
- Stores key-value pairs
- Broadcasts updates to connected clients
- Logs all operations to `log.txt`

## Client Setup and Operation

### Connecting to the Server

#### Method 1: Interactive Connection
1. Run `unu_db_cl.exe`
2. Enter server address when prompted (format: IP:PORT)

#### Method 2: Command Line Parameter
```
unu_db_cl.exe -addr [SERVER_IP]:[PORT]
```

#### Method 3: Using Configuration File
1. Ensure `server.conf` contains server address (format: IP:PORT)
2. Run:
```
unu_db_cl.exe -config server.conf
```

### Client Commands

#### Inserting a Value
- Format: `key=value`
- Example: `message=Hello, World!`

#### Retrieving a Value
- Format: Simply type the key
- Example: `message`

#### Special Commands
- `/help`: Display help information
- `/exit`: Close the client connection
- `version`: Get server version information

## Example Workflow
1. Start the server
2. Launch the client
3. Connect to the server
4. Insert values: `greeting=Hello`
5. Retrieve values: `greeting`

## Troubleshooting
- Ensure firewall allows UDP connections
- Verify server IP and port are correct
- Check network connectivity

## Limitations
- In-memory storage (data lost on restart)
- No persistent storage
- Simple broadcast mechanism
